/******************************************************************************
 *
 * File	Name:       evm_types.c
 *
 * Description: This file contains initializations for EVM Types.
 * 
 ******************************************************************************/
/****************************************************************************
 * Copyright (c) 2012 Texas Instruments Incorporated - http://www.ti.com
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#include "evm_types.h"

const unsigned long num_evm_types = 8;

const EVM_TYPE evm_types_list[] = {
    {
        "0.0.0.0",
        "K2KH-EVM",
        "K2KH-EVM"
    },
    {
        "0.0.0.1",
        "K2KH-EVM",
        "XTCIEVMK2X"
    },
    {
        "0.0.0.2",
        "K2KH-EVM",
        "XEVMK2HX"
    },
    {
        "0.0.0.3",
        "K2KH-EVM",
        "TCIEVMK2X"
    },
    {
        "0.0.0.4",
        "K2KH-EVM",
        "EVM2KHX"
    },
    {
        "0.0.0.5",
        "K2KH-EVM",
        "EVMK2H"
    },
    {
    	"0.0.0.6",
    	"K2E-EVM",
    	"EVMK2E"
    },
    {
    	"0.0.0.7",
    	"K2L-EVM",
    	"EVMK2L"
    }
};
