/******************************************************************************
 *
 * File	Name:       bmc_clk_gen.c
 *
 * Description: This contains a lookup table used for the clock generator registers.
 * 
 ******************************************************************************/
 /****************************************************************************
 * Copyright (c) 2012 Texas Instruments Incorporated - http://www.ti.com
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#include "bmc_clocks.h"

#if defined K2E || defined K2L
const int clk_gen_amount = 2;
const int clk_gen_reg_amount = 21;
#else
const int clk_gen_amount = 3;
const int clk_gen_reg_amount = 21;
#endif

#if defined K2L || defined K2E
unsigned long clkgen_profile[2][21] ={0};
#endif

unsigned short clkgen1[] = {
#ifdef K2E
/*0x*/   0x01B8, 0x0000, 0x0018, 0x08F4, 0x30AB, 0x0023, 0x0003, 0x0023, 0x0004, 0x4003,
/*1x*/   0x0000, 0x0000, 0x0003, 0x0030, 0x0000, 0x0003, 0x0040, 0x0000, 0x0003, 0x0040,
/*2x*/   0x0000
#elif defined K2L
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0000, 0x001F, 0x00F0, 0x30B3, 0x0022, 0x0004, 0x01BA, 0x0004, 0x0002,
/*1x*/   0x0040, 0x0000, 0x0002, 0x01F0, 0x0000, 0x0202, 0x0004, 0x0000, 0x0002, 0x0040,
/*2x*/   0x0000
#else
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x0009, 0x0000, 0x001F, 0x00F5, 0x30AF, 0x0023, 0x0004, 0x0023, 0x0004, 0x0003,
/*1x*/   0x01F0, 0x0000, 0x0003, 0x01F0, 0x0000, 0x0001, 0x0000, 0x0000, 0x0001, 0x0000,
/*2x*/   0x0000
#endif
};

#if !defined K2E
unsigned short clkgen1_10MHz_primary[] = {
#if !defined K2L
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x0009, 0x0060, 0x05FF, 0x00F5, 0x2097, 0x0023, 0x0004, 0x0023, 0x0004, 0x0003,
/*1x*/   0x01F0, 0x0000, 0x0003, 0x01F0, 0x0000, 0x0001, 0x0000, 0x0000, 0x0001, 0x0000,
/*2x*/   0x0000
#else
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0060, 0x05FF, 0x00F0, 0x208C, 0x0022, 0x0004, 0x01BA, 0x0004, 0x0002,
/*1x*/   0x0040, 0x0000, 0x0002, 0x01F0, 0x0000, 0x0202, 0x0004, 0x0000, 0x0002, 0x0040,
/*2x*/   0x0000
#endif
};
#endif

#ifdef K2L
unsigned short clkgen1_19_2MHz_primary[] = {
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0000, 0x001F, 0x00F0, 0x20CC, 0x0022, 0x0004, 0x01BA, 0x0004, 0x0002,
/*1x*/   0x0040, 0x0000, 0x0002, 0x01F0, 0x0000, 0x0202, 0x0004, 0x0000, 0x0002, 0x0040,
/*2x*/   0x0000
};
#endif

unsigned short clkgen2[] = {
#ifdef K2E
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0000, 0x0018, 0x08F4, 0x306B, 0x0103, 0x0001, 0x0023, 0x0004, 0x0203,
/*1x*/   0x0022, 0x0000, 0x0203, 0x0022, 0x0000, 0x0003, 0x0040, 0x0000, 0x0003, 0x0040,
/*2x*/   0x0000
#elif defined K2L
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0000, 0x0018, 0x00F4, 0x30EC, 0x0022, 0x0003, 0x0022, 0x0004, 0x0202,
/*1x*/   0x0022, 0x0000, 0x0202, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0310,
/*2x*/   0x0000
#else
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x03F1, 0x017C, 0x187C, 0x00F5, 0x20AF, 0x0023, 0x0003, 0x0001, 0x0031, 0x0203,
/*1x*/   0x01E4, 0x0000, 0x0001, 0x0000, 0x0000, 0x0001, 0x0000, 0x0000, 0x0011, 0x0310,
/*2x*/   0x0000
#endif
};

#ifdef K2L
unsigned short clkgen2_19_2MHz_primary[] = {
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x017C, 0x187C, 0x00F4, 0x20CC, 0x0022, 0x0003, 0x0022, 0x0004, 0x0202,
/*1x*/   0x0022, 0x0000, 0x0202, 0x0022, 0x0000, 0x0000, 0x0040, 0x0000, 0x0002, 0x0310,
/*2x*/   0x0000
};
#endif

#ifdef K2L
unsigned short clkgen2_25MHz_primary[] = {
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0000, 0x0018, 0x00F4, 0x20CC, 0x0022, 0x0003, 0x0022, 0x0004, 0x0202,
/*1x*/   0x0022, 0x0000, 0x0202, 0x0022, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0x0310,
/*2x*/   0x0000
};
#endif

#ifdef K2E
const unsigned short clkgen2_25MHz_primary[] = {
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x01B8, 0x0000, 0x0018, 0x08F4, 0x20F4, 0x0103, 0x0001, 0x0023, 0x0004, 0x0203,
/*1x*/   0x0022, 0x0000, 0x0203, 0x0022, 0x0000, 0x0003, 0x0040, 0x0000, 0x0003, 0x0040,
/*2x*/   0x0000
};
#endif


#if !defined K2E && !defined K2L
const unsigned short clkgen3[] = {
/*         0       1       2       3       4       5       6       7       8       9  */
/*0x*/   0x03F1, 0x0000, 0x0018, 0x00F5, 0x306F, 0x0023, 0x0001, 0x0023, 0x0004, 0x0203,
/*1x*/   0x0022, 0x0000, 0x0203, 0x0022, 0x0000, 0x0203, 0x0022, 0x0000, 0x0203, 0x0022,
/*2x*/   0x0000
};
#endif

const unsigned short *clkgen[] = {
    clkgen1
#if !defined K2E
    ,clkgen1_10MHz_primary
#ifdef K2L
    ,clkgen1_19_2MHz_primary
#endif
#endif
    ,clkgen2
#ifdef K2L
    ,clkgen2_19_2MHz_primary
    ,clkgen2_25MHz_primary
#endif
#ifdef K2E
    ,clkgen2_25MHz_primary
#endif
#if !defined K2E && !defined K2L
    ,clkgen3
#endif
};
